%
% Compute quarterly forecasts of standard FRBSF forecast variables and
%  write output to Excel workbook.
%

tablestartdate = 2012 ; % Table will begin with Q1 of this year and print out
                        %  data for year+1 and year+2.
fcastprevdate = [2012 10 24] ; % [yr mo dy] of previous frbsf fcast to compare (last FOMC)
fcastprevfridate = [2012 11 21] ; % [yr mo dy] of previous friday's frbsf fcast to compare
outfilestr1 = strcat(outfiledir,'/favarfcastsheet',sprintf('%4i%02i%02i',today(1:3))) ;
if strcmp(diffspecification,'yes'); outfilestr1 = strcat(outfilestr1,'diff.xls') ;
else outfilestr1 = strcat(outfilestr1,'.xls') ;
end ;
copyfile('data/templatesheet.xls',outfilestr1) ;

unempind = 16 ;
cpiind = 1 ;
cpixind = 2 ;
pceind = 3 ;
pcexind = 4 ;
poilind = 17 ;
ffrind = 1 ;
wilshind = 72 ;
dollarind = 10 ;

% write table and row headers:
rowhead{1,1} = strcat('Current forecast:',sprintf(' %i/%i/%i',today([2 3 1]))) ;
rowhead{2,1} = strcat('Previous forecast:',sprintf(' %i/%i/%i',fcastprevdate([2 3 1]))) ;
rowhead{1,19} = sprintf('%i/%i/%i',today([2 3 1])) ;
if (today(4)>12) ;
  rowhead{2,19} = sprintf('%i:%2i PM',today(4)-12,today(5)) ;
else ;
  rowhead{2,19} = sprintf('%i:%2i AM',today([4 5])) ;
end ;
if strcmp(diffspecification,'yes') ;
  rowhead{1,2} = 'Table 7b' ;
  rowhead{2,2} = 'FRBSF FAVAR Forecast (No-Gaps First-Difference Specification)' ;
else ;
  rowhead{1,2} = 'Table 7a' ;
  rowhead{2,2} = 'FRBSF FAVAR Forecast (Gaps Specification)' ;
end ;
xlswrite(outfilestr1,rowhead,'FRBSF Forecast Sheet','a1') ;
xlswrite(outfilestr1,rowhead,'Change From Yesterday','a1') ;
xlswrite(outfilestr1,rowhead,'Change From Last Friday','a1') ;

% write column headers:
colhead = cell(2,20) ;
colhead(1,[2 18]) = num2cell(tablestartdate) ;
colhead(1,[7 19]) = num2cell(tablestartdate+1) ;
colhead(1,[12 20]) = num2cell(tablestartdate+2) ;
colhead{1,17} = tablestartdate-1 ;
colhead(2,2:5:12) = cellstr('Q1') ;
colhead(2,3:5:13) = cellstr('Q2') ;
colhead(2,4:5:14) = cellstr('Q3') ;
colhead(2,5:5:15) = cellstr('Q4') ;
colhead(2,17:20) = cellstr('Q4/Q4') ;
xlswrite(outfilestr1,colhead,'FRBSF Forecast Sheet','a4') ;
xlswrite(outfilestr1,colhead,'Change From Yesterday','a4') ;
xlswrite(outfilestr1,colhead,'Change From Last Friday','a4') ;


startind = find(dates(:,1)==tablestartdate) ;
startind = startind(1) - burn ;

% Unemployment Rate Forecast:
unempq = mean(reshape(eafinal(startind-24:startind+35,unempind),3,20)) ;
unempq(21:24) = unempq(8:4:20) ; % avg Q4 level
unempq = unempq(9:24) ;

% Federal Funds Rate Forecast:
ffrq = mean(reshape(intfinal(startind-24:startind+35,ffrind),3,20)) ;
ffrq(21:24) = ffrq(8:4:20) ; % avg Q4 level
ffrq = ffrq(9:24) ;

% Price of Oil Forecast:
poilq = mean(reshape(prfinal(startind-24:startind+35,poilind),3,20)) ;
poilq(21:24) = poilq(8:4:20) - poilq(4:4:16) ; % Q4-to-Q4 chg in $/bbl
poilq = poilq(9:24) ;

% Trade-Weighted Dollar Forecast:
dollarq = mean(reshape(trafinal(startind-24:startind+35,dollarind),3,20)) ;
dollarq(21:24) = dollarq(8:4:20) - dollarq(4:4:16) ; % Q4-to-Q4 chg
dollarq = dollarq(9:24) ;


% CPI and PCE Forecasts:
cpilevq = mean(reshape(prfinal(startind-24:startind+35,cpiind),3,20)) ;
cpiq(1:12) = 100* ((cpilevq(9:20)./cpilevq(8:19)).^4 - 1) ;
cpiq(13:16) = 100* ((cpilevq(8:4:20)./cpilevq(4:4:16)) - 1) ; % Q4/Q4 % chg

cpixlevq = mean(reshape(prfinal(startind-24:startind+35,cpixind),3,20)) ;
cpixq(1:12) = 100* ((cpixlevq(9:20)./cpixlevq(8:19)).^4 - 1) ;
cpixq(13:16) = 100* ((cpixlevq(8:4:20)./cpixlevq(4:4:16)) - 1) ; % Q4/Q4 % chg

pcelevq = mean(reshape(prfinal(startind-24:startind+35,pceind),3,20)) ;
pceq(1:12) = 100* ((pcelevq(9:20)./pcelevq(8:19)).^4 - 1) ;
pceq(13:16) = 100* ((pcelevq(8:4:20)./pcelevq(4:4:16)) - 1) ; % Q4/Q4 % chg

pcexlevq = mean(reshape(prfinal(startind-24:startind+35,pcexind),3,20)) ;
pcexq(1:12) = 100* ((pcexlevq(9:20)./pcexlevq(8:19)).^4 - 1) ;
pcexq(13:16) = 100* ((pcexlevq(8:4:20)./pcexlevq(4:4:16)) - 1) ; % Q4/Q4 % chg

wilshq(1:12) = 100* ((eafinal(startind+2:3:startind+35,wilshind) ./ ...
                            eafinal(startind-1:3:startind+32,wilshind)) -1) ;
wilshq(13:16) = 100* ((eafinal(startind-1:12:startind+35,wilshind) ./ ...
                          eafinal(startind-13:12:startind+23,wilshind)) -1) ;

% NAIRU forecast:
if strcmp(diffspecification,'yes') ; % the no-gaps specification does not give us
  nairuq = repmat(NaN,1,16) ;        %  an estimate of the NAIRU
else ;
  nairuq = mean(reshape(trendhpt(startind-24:startind+35,find(hptindexes==unempind)),3,20)) ;
  nairuq(21:24) = nairuq(8:4:20) ; % avg Q4 level
  nairuq = nairuq(9:24) ;
end ;


% Compute quarterly output gap, GDP, and potential output forecasts for forecast sheet:

if strcmp(diffspecification,'yes') ; % the no-gaps specification does not give us
  gdpq(1:12) = 100* ((gdpm(startind+2:3:startind+35) ./ ...
                                     gdpm(startind-1:3:startind+32)).^4 -1) ;
  gdpq(13:16) = 100* ((gdpm(startind-1:12:startind+35) ./ ...
                                     gdpm(startind-13:12:startind+23)) -1) ;
  gdpgapq = repmat(NaN,1,16) ;       %  an estimate of the output gap
  potgdpq = repmat(100*(exp(4*Dlgdpmean)-1),1,16) ;
else ;
  gdplevq = exp(mean(reshape(lgdpm(startind-24:startind+35),3,20))) ;
  gdpq(1:12) = 100* ((gdplevq(9:20)./gdplevq(8:19)).^4 - 1) ;
  gdpq(13:16) = 100* ((gdplevq(8:4:20)./gdplevq(4:4:16)) - 1) ; % Q4/Q4 % chg

  potgdplevq = exp(mean(reshape(trendgdpm(startind-24:startind+35),3,20))) ;
  potgdpq(1:12) = 100* ((potgdplevq(9:20)./potgdplevq(8:19)).^4 - 1) ;
  potgdpq(13:16) = 100* ((potgdplevq(8:4:20)./potgdplevq(4:4:16)) - 1) ; % Q4/Q4 % chg

  gdpgapq = 100* ((gdplevq ./ potgdplevq) - 1) ;
  gdpgapq(21:24) = mean(reshape(gdpgapq(5:20),4,4)) ; % avg annual level
  gdpgapq = gdpgapq(9:24) ;
end ;

%
% Collect forecasts together into one variable:
%

fcastq = [gdpq; unempq; cpiq; cpixq; pceq; pcexq; potgdpq; gdpgapq; nairuq; ...
    ffrq; poilq; wilshq; dollarq] ;

%
% Read in forecast from day of last FOMC meeting for comparison:
%

infileprev = strcat('results/',sprintf('%4i%02i%02i',fcastprevdate),'/favarfcastsheet',...
    sprintf('%4i%02i%02i',fcastprevdate)) ;
if strcmp(diffspecification,'yes'); infileprev = strcat(infileprev,'diff.xls') ;
else infileprev = strcat(infileprev,'.xls') ;
end ;
fcastprev = xlsread(infileprev,'FRBSF Forecast Sheet') ;
fcastprev = fcastprev([6:3:42],[1:4 6:9 11:14 16:19]) ;

fcastdiff = fcastq - fcastprev ;

%
% Read in most recent forecast for comparison:
%

dirlist = dir('results') ;
dlist = {dirlist.name} ;
todayind = find(strcmp(dlist,sprintf('%4i%02i%02i',today(1:3)))) ;
if isempty(todayind); todayind = length(dlist)+1; end ;
yeststr = cell2mat(dlist(todayind-1)) ;
infileprev1 = strcat('results/',yeststr,'/favarfcastsheet',yeststr) ;
if strcmp(diffspecification,'yes'); infileprev1 = strcat(infileprev1,'diff.xls') ;
else infileprev1 = strcat(infileprev1,'.xls') ;
end ;
fcastprev1 = xlsread(infileprev1,'FRBSF Forecast Sheet') ;
fcastprev1 = fcastprev1([6:3:42],[1:4 6:9 11:14 16:19]) ;

fcastdiff1 = fcastq - fcastprev1 ;

yestdate = [str2double(yeststr(1:4)), str2double(yeststr(5:6)), str2double(yeststr(7:8))] ;

%
% Read in forecast from previous Friday for comparison:
%

infileprevfri = strcat('results/',sprintf('%4i%02i%02i',fcastprevfridate),'/favarfcastsheet',...
    sprintf('%4i%02i%02i',fcastprevfridate)) ;
if strcmp(diffspecification,'yes'); infileprevfri = strcat(infileprevfri,'diff.xls') ;
else infileprevfri = strcat(infileprevfri,'.xls') ;
end ;
fcastprevfri = xlsread(infileprevfri,'FRBSF Forecast Sheet') ;
fcastprevfri = fcastprevfri([6:3:42],[1:4 6:9 11:14 16:19]) ;

fcastdiff2 = fcastq - fcastprevfri ;


%
% Write forecast data to Excel forecast sheet:
%

dataout = cell(45,20) ;
dataout([7:3:43],[2:5 7:10 12:15 17:20]) = num2cell(fcastq) ;
dataout1 = dataout ;
dataout2 = dataout ;
dataout([8:3:44],[2:5 7:10 12:15 17:20]) = num2cell(fcastdiff) ;
dataout1([8:3:44],[2:5 7:10 12:15 17:20]) = num2cell(fcastdiff1) ;
dataout2([8:3:44],[2:5 7:10 12:15 17:20]) = num2cell(fcastdiff2) ;

xlswrite(outfilestr1,dataout1(7:45,2:20),'Change From Yesterday','b7') ;
xlswrite(outfilestr1,dataout2(7:45,2:20),'Change From Last Friday','b7') ;
xlswrite(outfilestr1,{sprintf('changes from %i/%i/%i',yestdate([2 3 1]))},...
                                                'Change From Yesterday','a2') ;
xlswrite(outfilestr1,{sprintf('changes from %i/%i/%i',fcastprevfridate([2 3 1]))},...
                                                'Change From Last Friday','a2') ;
xlswrite(outfilestr1,dataout(7:45,2:20),'FRBSF Forecast Sheet','b7') ;
